/************************************************************************
 * inverse discrete cosine transform                                    *
 ************************************************************************/

#include <stdio.h>
#include "idct.h"
#include "jpeg.h"

void idct_init(DOLProcess *p) {
    p->local->num_iter = 0;
}

int idct_fire(DOLProcess *p) {
    int block[8][8];
    unsigned char idct[8][8];
    int i;

    for (i = 0; i < NB_SEND; i++) {
        DOL_read((void*)PORT_IN1, &block[MAX_SEND * i],
                MAX_SEND * sizeof(block[0][0]), p);
    }

    IDCT(block, idct);

    for (i = 0; i < NB_SEND; i++) {
        DOL_write((void*)PORT_OUT1, &idct[MAX_SEND * i],
                MAX_SEND * sizeof(idct[0][0]), p);
    }

    //end this process
    p->local->num_iter++;
    if (p->local->num_iter == NUMBER_OF_FRAMES * 1200) {
        DOL_detach(p);
        return 0;
    }

    return 0;
}
