#ifndef PROCESSFRAME_H
#define PROCESSFRAME_H

#include <dol.h>

#define PORT_IN1   "in1"
#define PORT_IN2   "in2"
#define PORT_OUT1  "out1"
#define PORT_OUT2  "out2"

//local variables
typedef struct _local_states {
    char frame[MAX_ENCODED_FRAME]; //frame
    int fLen;                      //frame size
    char *fptr;                    //current read ptr
    VLD_State vld;                 //VLD state
    int num_iter;                  //number of iteration
    unsigned char ColorBuffer[MCU_sx * MCU_sy];
    unsigned char LineBuffer[MAX_WIDTH * MCU_sx];
    int dataBuff[(MAX_WIDTH * MCU_sy) / 4];
} Processframe_State;

void processframe_init(DOLProcess *);
int processframe_fire(DOLProcess *);

#endif
