/************************************************************************
 * ziz-zag scan                                                         *
 ************************************************************************/

#include <stdio.h>
#include "zigzag.h"
#include "jpeg.h"

void zigzag_init(DOLProcess *p) {
    p->local->num_iter = 0;
}

int zigzag_fire(DOLProcess *p) {
    int ZZ[64];
    int UnZZ[64];
    int i;

    for (i = 0; i < NB_SEND; i++) { //get block
        DOL_read((void*)PORT_IN1, &ZZ[MAX_SEND*i],
                 MAX_SEND * sizeof(ZZ[0]), p);
    }

    unZigZag(UnZZ, ZZ);

    for (i=0;i<NB_SEND;i++) { //send block
        DOL_write((void*)PORT_OUT1, &UnZZ[MAX_SEND*i],
                  MAX_SEND * sizeof(UnZZ[0]), p);
    }

    //end this process
    p->local->num_iter++;
    if (p->local->num_iter == NUMBER_OF_FRAMES * 1200) {
        DOL_detach(p);
        return 0;
    }

    return 0;
}

